#include <DHT.h>

// Liberia para emplear el sensor
#include "DHT.h"

// Pin donde esta conectado el pin DATA (Entradas digitales)
#define DHTPIN 2

// Descomentar el tipo de sensor empleado
#define DHTTYPE DHT11// DHT 11
// #define DHTTYPE DHT22//DHT22(AM2302)
// #define DHTTYPE DHT21//DHT21(AM2301)

// Inicliza una variable de tipo DHT para poder emplear el sensor
DHT dht(DHTPIN,DHTTYPE);//Indica el pin con el que trabajamos y el tipo de sensor

int maxh=0, minh=100, maxt=0, mint=100;  //Variables para ir comprobando maximos y minimos

int value;

void setup()
{
  // Inicializaicón comunicacion serie para ver los datos en el ordenador
  Serial.begin(9600);
  Serial.println("Comprobacion sensor DHTxx:");
  
  //Iniciamos el sensor
  dht.begin();
}

void loop()
{

  // Leemos temperatura y humedad. Es un sensor lento.
  int h = dht.readHumidity();
  int t = dht.readTemperature();

  // Comprobamos si lo que nos ha devuelto el sensor son numeros correctos.
  if (isnan(t) || isnan(h))
  {
    Serial.println("Fallo al leer del sensor DHT"); //Mostramos mensaje de fallo si no son numeros
  } else {
    
    //Mostramos mensaje con valores actuales de humedad y temperatura
    Serial.print("Humedad relativa: ");
    Serial.print(h);
    Serial.print(" %\t");
    Serial.print("Temperatura: ");
    Serial.print(t);
    Serial.println(" *C");
    
    
    
    // Comprobacion de maximos y minimos de humedad y temperatura
    if (maxh<h)
      maxh=h;
      
    if (h<minh)
      minh=h;
      
    if (maxt<t)
      maxt=t;
      
    if (t<mint)
      mint=t;
    
    // MEnsajes de maximos y minimos
    Serial.print("Max: ");
    Serial.print(maxh);
    Serial.print(" % ");
    Serial.print("Min: ");
    Serial.print(minh);
    Serial.print(" %\t");
    
    Serial.print("Max: ");
    Serial.print(maxt);
    Serial.print(" *C ");
    Serial.print("Min: ");
    Serial.print(mint);
    Serial.println(" *C\n");
  }
  
  // Pequeña pausa. 1sg
  delay(1000);
}
